/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
struct MenuNew // new-game menu
{
   Window window;
   Text   text;
   Button close;
   
   static void Close(Ptr){Mn.window.fadeOut();}
   void create()
   {
      Gui   +=window.create(Rect_C(0,0,0.9,0.5)).barVisible(false).hide();
      window+=text  .create(Vec2  (window.crect.w()/2,-0.15),"New Game");
      window+=close .create(Rect_C(window.crect.w()/2,-window.crect.h()/2-0.1,0.4,0.08),"Close",Close);
   }
}Mn;
/******************************************************************************/
struct MenuLoad // load-game menu
{
   Window window;
   Text   text;
   Button close;
   
   static void Close(Ptr){Ml.window.fadeOut();}
   void create()
   {
      Gui   +=window.create(Rect_C(0,0,0.9,0.5)).barVisible(false).hide();
      window+=text  .create(Vec2  (window.crect.w()/2,-0.15),"Load Game");
      window+=close .create(Rect_C(window.crect.w()/2,-window.crect.h()/2-0.1,0.4,0.08),"Close",Close);
   }
}Ml;
/******************************************************************************/
struct MenuOptions // options menu
{
   Window window;
   Text   text;
   Button close;
   
   static void Close(Ptr){Mo.window.fadeOut();}
   void create()
   {
      Gui   +=window.create(Rect_C(0,0,0.9,0.5)).barVisible(false).hide();
      window+=text  .create(Vec2  (window.crect.w()/2,-0.15),"Options");
      window+=close .create(Rect_C(window.crect.w()/2,-window.crect.h()/2-0.1,0.4,0.08),"Close",Close);
   }
}Mo;
/******************************************************************************/
struct MenuMain // main menu
{
   Window window;
   Button b_new,b_load,b_options,b_exit;

   static void New    (Ptr){Mn.window.fadeIn();}
   static void Load   (Ptr){Ml.window.fadeIn();}
   static void Options(Ptr){Mo.window.fadeIn();}
   static void Exit   (Ptr){StateExit.set();}
   void create()
   {
      Gui   +=window   .create(Rect_C(0,-0.1,0.6,0.6)).barVisible(false);
      window+=b_new    .create(Rect_C(window.crect.w()/2,-0.15,0.4,0.08),"New"    ,New);
      window+=b_load   .create(Rect_C(window.crect.w()/2,-0.25,0.4,0.08),"Load"   ,Load);
      window+=b_options.create(Rect_C(window.crect.w()/2,-0.35,0.4,0.08),"Options",Options);
      window+=b_exit   .create(Rect_C(window.crect.w()/2,-0.45,0.4,0.08),"Exit"   ,Exit);
      window.flag&=~WIN_MOVABLE; // disable moving of this window
      window.level=-1          ; // set lower level so this window will be always below the other created in this tutorial
   }
}Mm;
/******************************************************************************/
void InitPre()
{
   App.name="Game Menu";
   App.flag=APP_FULL_TOGGLE; // we'll be using GUI effects (window fading) so make sure APP_NO_FX isn't selected
   PakAdd("../data/engine.pak");
   D.mode(800,600).sync(true);
}
/******************************************************************************/
Bool Init()
{
   // in games disable highlighting elements with keyboard focus
   Gui.kb_lit=0;

   // change default gui text colors
   Gui.tds_text.color=WHITE;
   Gui.tds_text.shadow=255;

   // change Default Gui Window Style
   Gui.style_window.gfx_back    =Gfxs("../data/Gui/Style/0/back.gfx");
   Gui.style_window.gfx_border  =Gfxs("../data/Gui/Style/0/border.gfx");
   Gui.style_window.border_color=WHITE;
   Gui.style_window.back_color  =BLUE;
   Gui.style_window.border_width=0.03;

   Mn.create();
   Ml.create();
   Mo.create();
   Mm.create();
   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();
   return true;
}
/******************************************************************************/
void Draw()
{
   D  .clear();
   Gui.draw ();
}
/******************************************************************************/
